# Modal Forms (Updated for Server UI v2.0.0)

Modal Forms allow flexible and structured input from players, with the ability to connect inputs to actions using the `value` field. Each element in the form is assigned a `value` that links it to the expected field in the action’s `onSubmit` object.

> ⚠️ **Credit:** This system was originally inspired by the Form Builder and `actionChain` structure created by AxisCube. However, the underlying logic, dynamic templating, modular handlers, and form integration have been extensively redesigned and expanded by TheDiamondBlue1 into a fully custom framework.

## 🧠 Element Mapping
Each element must contain a `type`, and optionally:
- `label`: Title of the field (for input types)
- `tooltip`: Description shown when hovering or selecting
- `value`: Key that connects the field’s result to the action logic

Special formatting elements include:
- `header`: Large, bold title for section breaks
- `label`: Static description text
- `divider`: Visual line separator

## 📋 Example Modal Form Structure
```js
{
  type: "modal",
  title: "Apply Tag",
  elements: [
    { type: "header", headerText: "Target Info" },
    {
      type: "player",
      label: "Select a Player",
      tooltip: "The player you want to tag",
      value: "selector"
    },
    { type: "divider" },
    {
      type: "textField",
      label: "Tag Name",
      tooltip: "Enter the tag to add",
      value: "tag"
    },
    {
      type: "submitButton",
      label: "Add Tag",
      onSubmit: [
        {
          type: "add_tag",
          value: {
            selector: "selector",
            tag: "tag"
          }
        }
      ]
    }
  ]
}
```

---

## 🗨️ Message Forms
Used for simple Yes/No confirmation dialogs.

### Supported `elements`:
- `button1` → Left-side button
- `button2` → Right-side button

Each button can include an `onClick` array of actions.

### 📋 Example Message Form
```js
{
  type: "message",
  title: "Confirm Action",
  body: "Do you really want to give yourself 64 diamonds?",
  elements: [
    {
      type: "button1",
      label: "No",
      onClick: [
        { type: "say", value: "Cancelled." }
      ]
    },
    {
      type: "button2",
      label: "Yes",
      onClick: [
        { type: "give", value: { selector: "self", itemId: "minecraft:diamond", amount: 64 } }
      ]
    }
  ]
}
```

---

## ✅ Confirm Action Type
Used within submit buttons or other actions to require a second confirmation before running an action.

### 🔑 Fields:
- `type: "confirm"`
- `value`: The values to be injected (optional, usually inherited from modal)
- `body`: The message shown in the confirmation (supports `{#KEY}` placeholders)
- `confirmText`: Label for confirm button
- `cancelText`: Label for cancel button
- `confirmAction`: Actions to run if confirmed
- `cancelAction`: Actions to run if denied (e.g. reopen previous form)

### 📋 Example:
```js
{
  type: "confirm",
  value: {
    selector: "selector",
    gamemode: "gamemode"
  },
  body: "Are you sure you want to change {#SELECTOR}'s gamemode to {#GAMEMODE}?",
  confirmText: "Yes",
  cancelText: "No",
  confirmAction: [
    { type: "gamemode", value: "{#GAMEMODE}" }
  ],
  cancelAction: [
    { type: "form", value: "changeGameMode" }
  ]
}
```

Dynamic values like `{#SELECTOR}` and `{#GAMEMODE}` will be replaced with the actual inputted values using the `valueMap` from the parent modal form.

---

## 🚀 New Supported Actions

The system now supports an extended list of `actionChain` and `actionChainModal` types with runtime injection, placeholder templating, and form context support:

### ✅ Supported `actionChain` Types
- `give`D
- `say`D
- `eval`D
- `sound`D
- `cmds`D
- `cmd`D
- `tellraw`D
- `scoreboard`
- `gamemode`D
- `form`D
- `teleport` / `tp`D
- `effect`
- `add_tag`D
- `remove_tag`D

### ✅ Supported `actionChainModal` Types
- `confirm`D
- `give`D
- `add_tag`D
- `gamemode`D
- `remove_tag`D
- `effect`D
- `scoreboard`D
- `message`D
- `teleport` / `tp`D
- `sound`
- `sendMessage`
- `broadcast`
- `customFormReturn`
- `formRedirect`

### Bonus:
- All string values in actions support `{#KEY}` format to inject data from modal field values.
- Teleportation supports `dimension`, `coordinates`, and `player to player`.

---

## 🔍 Selector Behaviour
For all modal actions, `selector` can be:
- `"self"` → The player who submitted the form
- `"all"` → All online players *(use cautiously)*
- A player's name from a player dropdown

## 🔄 Value Mapping and Fallbacks
When the form is submitted, the system checks whether a field's value exists in the input (`valueMap`).
- If it exists, the resolved value is injected.
- If it doesn’t, the value itself is treated as a constant (e.g. `"self"`, `"Wins"`).
- You can also use `{#KEY}` inside any string to dynamically substitute form values.

## 🧩 Form Element Flexibility
Any field (except for `selector`) can be captured using any supported input:
- `textField`
- `dropdown`
- `slider`
- `toggle`

For example:
```js
{ type: "dropdown", label: "Tag", value: "tag", items: ["vip", "staff"] }
```

---

This builder now supports full layout control, flexible inputs, message and confirmation forms, dynamic templating with runtime-injected data, teleportation with dimensions, and dozens of custom actions — making it a full-featured dev tool for creating rich, interactive form systems.
